/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.ISimpleBrushable;
import net.mehvahdjukaar.supplementaries.common.entities.FallingAshEntity;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AshLayerBlock
extends ColoredFallingBlock
implements ISimpleBrushable {
    public static final MapCodec<AshLayerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ColorRGBA.CODEC.fieldOf("falling_dust_color").forGetter(coloredFallingBlock -> coloredFallingBlock.dustColor), (App)AshLayerBlock.propertiesCodec()).apply((Applicative)instance, AshLayerBlock::new));
    private static final int MAX_LAYERS = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[9];
    public static final ThreadLocal<Boolean> RECURSION_HACK;
    public static final int GRASS_SPREAD_WIDTH = 3;

    public AshLayerBlock(ColorRGBA color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public MapCodec<ColoredFallingBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean brush(BlockState state, BlockPos pos, Level level, ItemStack stack, Player livingEntity, HumanoidArm arm, BlockHitResult hit, Vec3 particlesDir) {
        int layers = (Integer)state.getValue((Property)LAYERS);
        if (layers > 1) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers - 1)));
        } else {
            level.removeBlock(pos, false);
        }
        this.spawnBrushParticles(level, hit, (ParticleOptions)ModParticles.ASH_PARTICLE.get(), particlesDir, arm);
        level.playSound(livingEntity, pos, SoundEvents.BRUSH_SAND, SoundSource.BLOCKS);
        return true;
    }

    private void spawnBrushParticles(Level level, BlockHitResult hitResult, ParticleOptions particles, Vec3 del, HumanoidArm arm) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.getRandom().nextInt(12, 16);
        Direction direction = hitResult.getDirection();
        Vec3 pos = hitResult.getLocation();
        del = del.scale((double)0.1f);
        for (int k = 0; k < j; ++k) {
            level.addParticle(particles, pos.x - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), pos.y, pos.z - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), del.x() * (double)i * 3.0 * level.getRandom().nextDouble(), 0.0, del.z() * (double)i * 3.0 * level.getRandom().nextDouble());
        }
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult pHit, Projectile projectile) {
        ThrownPotion potion;
        BlockPos pos = pHit.getBlockPos();
        if (projectile instanceof ThrownPotion && ((PotionContents)(potion = (ThrownPotion)projectile).getItem().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER)) {
            boolean flag;
            Entity entity = projectile.getOwner();
            boolean bl = flag = entity == null || entity instanceof Player || PlatHelper.isMobGriefingOn((Level)level, (Entity)entity);
            if (flag) {
                this.removeOneLayer(state, pos, level);
            }
        }
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.getBlock() != oldState.getBlock()) {
            worldIn.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext c;
        Entity e;
        if (pContext instanceof EntityCollisionContext && (e = (c = (EntityCollisionContext)pContext).getEntity()) instanceof LivingEntity) {
            return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS) - 1];
        }
        return this.getShape(pState, pLevel, pPos, pContext);
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathType) {
        if (pathType == PathComputationType.LAND) {
            return (Integer)state.getValue((Property)LAYERS) <= 4;
        }
        return false;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos otherPos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            BlockPos pos = currentPos.above();
            BlockState state1 = world.getBlockState(pos);
            while (state1.is((Block)this)) {
                serverLevel.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
                pos = pos.above();
                state1 = serverLevel.getBlockState(pos);
            }
            AshLayerBlock.updateBasaltBelow(currentPos, (Level)serverLevel);
        }
        return super.updateShape(state, direction, facingState, world, currentPos, otherPos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRand) {
        BlockState below = level.getBlockState(pos.below());
        if ((FallingAshEntity.isFree(below) || this.hasIncompleteAshPileBelow(below)) && pos.getY() >= level.getMinBuildHeight()) {
            while (state.is((Block)this)) {
                FallingAshEntity fallingblockentity = FallingAshEntity.fall((Level)level, pos, state);
                this.falling((FallingBlockEntity)fallingblockentity);
                pos = pos.above();
                state = level.getBlockState(pos);
            }
        }
    }

    private boolean hasIncompleteAshPileBelow(BlockState state) {
        return state.is((Block)this) && (Integer)state.getValue((Property)LAYERS) != 8;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)this)) {
            int i = (Integer)blockstate.getValue((Property)LAYERS);
            return (BlockState)blockstate.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.getStateForPlacement(context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LAYERS});
    }

    public void randomTick(BlockState pState, ServerLevel level, BlockPos pPos, RandomSource pRandom) {
        if (CommonConfigs.Building.ASH_RAIN.get().booleanValue() && level.isRainingAt(pPos.above()) && level.random.nextInt(4) == 0) {
            this.removeOneLayer(pState, pPos, (Level)level);
        }
    }

    public void handlePrecipitation(BlockState pState, Level level, BlockPos pPos, Biome.Precipitation pPrecipitation) {
        super.handlePrecipitation(pState, level, pPos, pPrecipitation);
        if (CommonConfigs.Building.ASH_RAIN.get().booleanValue() && level.random.nextInt(2) == 0) {
            this.removeOneLayer(pState, pPos, level);
        }
    }

    private void removeOneLayer(BlockState state, BlockPos pos, Level level) {
        int levels = (Integer)state.getValue((Property)LAYERS);
        if (levels > 1) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(levels - 1)));
        } else {
            level.removeBlock(pos, false);
        }
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext useContext) {
        int i = (Integer)pState.getValue((Property)LAYERS);
        if (useContext.getItemInHand().is(this.asItem()) && i < 8) {
            boolean ret = true;
            if (RECURSION_HACK.get().booleanValue()) {
                return true;
            }
            RECURSION_HACK.set(true);
            if (useContext.replacingClickedOnBlock()) {
                ret = useContext.getClickedFace() == Direction.UP;
            }
            RECURSION_HACK.set(false);
            return ret;
        }
        return i <= 3;
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return true;
    }

    public static void tryConvertToAsh(IFireConsumeBlockEvent event) {
        double chance = CommonConfigs.Building.ASH_BURN_CHANCE.get();
        BlockState state = event.getState();
        if (chance != 0.0 && state.isSolid()) {
            int layers;
            LevelAccessor level = event.getLevel();
            BlockPos pos = event.getPos();
            if (event.getFinalState() != null) {
                return;
            }
            Item i = state.getBlock().asItem();
            int count = PlatHelper.getBurnTime((ItemStack)i.getDefaultInstance()) / 100;
            if (i.builtInRegistryHolder().is(ItemTags.LOGS_THAT_BURN)) {
                count += 2;
            }
            if (count > 0 && (layers = Mth.clamp((int)level.getRandom().nextInt(count), (int)1, (int)8)) != 0) {
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    sl.sendParticles((ParticleOptions)ModParticles.ASH_PARTICLE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10 + layers, 0.5, 0.5, 0.5, 0.0);
                }
                event.setFinalState((BlockState)ModRegistry.ASH_BLOCK.get().defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers)));
            }
        }
    }

    private void addParticle(Entity entity, BlockPos pos, Level level, int layers, float upSpeed) {
        level.addParticle((ParticleOptions)ModParticles.ASH_PARTICLE.get(), entity.getX(), (double)((float)pos.getY() + (float)layers * 0.125f), entity.getZ(), (double)(Mth.randomBetween((RandomSource)level.random, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)upSpeed, (double)(Mth.randomBetween((RandomSource)level.random, (float)-1.0f, (float)1.0f) * 0.083333336f));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.isClientSide && (!(entity instanceof LivingEntity) || entity.getBlockStateOn().is((Block)this))) {
            boolean bl;
            boolean bl2 = bl = entity.xOld != entity.getX() || entity.zOld != entity.getZ();
            if (bl && level.random.nextInt(2) == 0) {
                this.addParticle(entity, pos, level, (Integer)state.getValue((Property)LAYERS), 0.05f);
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float height) {
        int layers = (Integer)state.getValue((Property)LAYERS);
        entity.causeFallDamage(height, layers > 2 ? 0.3f : 1.0f, level.damageSources().fall());
        if (level.isClientSide) {
            int i = 0;
            while ((double)i < Math.min(12.0, (double)height * 1.4)) {
                this.addParticle(entity, pos, level, layers, 0.12f);
                ++i;
            }
        }
    }

    public static boolean applyBonemeal(ItemStack stack, Level level, BlockPos pos, Player player) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = level.getBlockState(pos);
        Block block = blockstate.getBlock();
        if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, blockstate)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (bonemealableblock.isBonemealSuccess(level, level.random, pos, blockstate)) {
                    bonemealableblock.performBonemeal(serverLevel, level.random, pos, blockstate);
                }
                stack.shrink(1);
            }
            return true;
        }
        return false;
    }

    public static boolean updateBasaltBelow(BlockPos selfPos, Level level) {
        if (level.getBlockState(selfPos.below()) == Blocks.BASALT.defaultBlockState()) {
            level.setBlock(selfPos.below(), ModRegistry.ASHEN_BASALT.get().defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        AshLayerBlock.updateBasaltBelow(pos, level);
    }

    public void onLand(Level level, BlockPos pos, BlockState state, BlockState replaceableState, FallingBlockEntity fallingBlock) {
        super.onLand(level, pos, state, replaceableState, fallingBlock);
        AshLayerBlock.updateBasaltBelow(pos, level);
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)Math.max(0.5, (double)l * 2.0), (double)16.0));
        RECURSION_HACK = ThreadLocal.withInitial(() -> false);
    }
}

